#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

dks_init_var_file=$1

#------------------- Переменные ---------------------------------------------------
tag_ver=$($dks_bashfile_dir/dks_const_var.sh           tag_ver)
tag_year=$($dks_bashfile_dir/dks_const_var.sh          tag_year)
db_bin_path=$($dks_bashfile_dir/dks_const_var.sh       db_bin_path)
db_lib_path=$($dks_bashfile_dir/dks_const_var.sh       db_lib_path)
db_kslib_path=$($dks_bashfile_dir/dks_const_var.sh     db_kslib_path)
dks_inst_path=$($dks_bashfile_dir/dks_const_var.sh     dks_inst_path)


dks_cont_name=$($dks_bashfile_dir/${dks_init_var_file} dks_cont_name)
dks_serv_name=$($dks_bashfile_dir/${dks_init_var_file} dks_serv_name)

util_path=$($dks_bashfile_dir/${dks_init_var_file}     util_path)
tag_name=$($dks_bashfile_dir/${dks_init_var_file}      tag_name)
db_port=$($dks_bashfile_dir/${dks_init_var_file}       db_port)
db_data_path=$($dks_bashfile_dir/${dks_init_var_file}  db_data_path)
contsoft=$($dks_bashfile_dir/${dks_init_var_file}      contsoft)


# экранируем символ слеш пути, т.к.возникает  ошибка при использовании sed
db_bin_path_template=$(echo "${db_bin_path}"| sed 's/\//\\\//g')
db_kslib_path_template=$(echo "${db_kslib_path}"| sed 's/\//\\\//g')
db_data_path_template=$(echo "${db_data_path}"| sed 's/\//\\\//g')

mkdir -p ${util_path}

#----------------------  bash.sh -----------------------------------------------------

cp ${dks_inst_path}/template/bash.sh.t                   ${util_path}/bash.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/bash.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/bash.sh
sed -i 's/@db_port@/'${db_port}'/g'                      ${util_path}/bash.sh
sed -i 's/@dks_cont_name@/'${dks_cont_name}'/g'          ${util_path}/bash.sh
sed -i 's/@db_kslib_path@/'${db_kslib_path_template}'/g' ${util_path}/bash.sh
sed -i 's/@contsoft@/'${contsoft}'/g'                    ${util_path}/bash.sh


chmod 777 ${util_path}/bash.sh

#----------------------  const_var.sh.t ---------------------------------------------

cp ${dks_inst_path}/template/const_var.sh.t              ${util_path}/const_var.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/const_var.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/const_var.sh

chmod 777 ${util_path}/const_var.sh

#----------------------  pg_promote.t ------------------------------------------------

cp ${dks_inst_path}/template/pg_promote.t                ${util_path}/pg_promote.t
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/pg_promote.t
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/pg_promote.t
sed -i 's/@db_port@/'${db_port}'/g'                      ${util_path}/pg_promote.t
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'     ${util_path}/pg_promote.t
sed -i 's/@db_kslib_path@/'${db_kslib_path_template}'/g' ${util_path}/pg_promote.t

chmod 644 ${util_path}/pg_promote.t

#----------------------  psql.sh -----------------------------------------------------

cp ${dks_inst_path}/template/psql.sh.t                   ${util_path}/psql.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/psql.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/psql.sh
sed -i 's/@db_port@/'${db_port}'/g'                      ${util_path}/psql.sh
sed -i 's/@dks_cont_name@/'${dks_cont_name}'/g'          ${util_path}/psql.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'     ${util_path}/psql.sh
sed -i 's/@db_kslib_path@/'${db_kslib_path_template}'/g' ${util_path}/psql.sh
sed -i 's/@contsoft@/'${contsoft}'/g'                    ${util_path}/psql.sh

chmod 777 ${util_path}/psql.sh

#----------------------  sr_info.sh ---------------------------------------------------

cp ${dks_inst_path}/template/sr_info.sh.t                ${util_path}/sr_info.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/sr_info.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/sr_info.sh
sed -i 's/@db_port@/'${db_port}'/g'                      ${util_path}/sr_info.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'     ${util_path}/sr_info.sh

#----------------------  sr_register.sh -----------------------------------------------

cp ${dks_inst_path}/template/sr_register.sh.t            ${util_path}/sr_register.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/sr_register.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/sr_register.sh
sed -i 's/@db_port@/'${db_port}'/g'                      ${util_path}/sr_register.sh

#----------------------  sr_prepare.sh ------------------------------------------------

cp ${dks_inst_path}/template/sr_prepare.sh.t             ${util_path}/sr_prepare.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/sr_prepare.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/sr_prepare.sh
sed -i 's/@tag_name@/'${tag_name}'/g'                    ${util_path}/sr_prepare.sh

sed -i 's/@db_port@/'${db_port}'/g'                      ${util_path}/sr_prepare.sh
sed -i 's/@dks_serv_name@/'${dks_serv_name}'/g'          ${util_path}/sr_prepare.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'     ${util_path}/sr_prepare.sh
sed -i 's/@db_data_path@/'${db_data_path_template}'/g'   ${util_path}/sr_prepare.sh
sed -i 's/@db_kslib_path@/'${db_kslib_path_template}'/g' ${util_path}/sr_prepare.sh

#----------------------  sr_recover_node_as_standby.sh -------------------------------

cp ${dks_inst_path}/template/sr_recover_node_as_standby.sh.t ${util_path}/sr_recover_node_as_standby.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                        ${util_path}/sr_recover_node_as_standby.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                          ${util_path}/sr_recover_node_as_standby.sh
sed -i 's/@db_port@/'${db_port}'/g'                          ${util_path}/sr_recover_node_as_standby.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'         ${util_path}/sr_recover_node_as_standby.sh
sed -i 's/@db_data_path@/'${db_data_path_template}'/g'       ${util_path}/sr_recover_node_as_standby.sh


#----------------------  sr_rejoin_node_as_standby.sh ------------------------------

cp ${dks_inst_path}/template/sr_rejoin_node_as_standby.sh.t  ${util_path}/sr_rejoin_node_as_standby.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                        ${util_path}/sr_rejoin_node_as_standby.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                          ${util_path}/sr_rejoin_node_as_standby.sh
sed -i 's/@db_port@/'${db_port}'/g'                          ${util_path}/sr_rejoin_node_as_standby.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'         ${util_path}/sr_rejoin_node_as_standby.sh
sed -i 's/@db_data_path@/'${db_data_path_template}'/g'       ${util_path}/sr_rejoin_node_as_standby.sh

#----------------------  sr_repmgrd.sh -----------------------------------------------

cp ${dks_inst_path}/template/sr_repmgrd.sh.t             ${util_path}/sr_repmgrd.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/sr_repmgrd.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/sr_repmgrd.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'     ${util_path}/sr_repmgrd.sh

#----------------------  sr_run.sh -----------------------------------------------------

cp ${dks_inst_path}/template/sr_run.sh.t                 ${util_path}/sr_run.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/sr_run.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/sr_run.sh
sed -i 's/@db_port@/'${db_port}'/g'                      ${util_path}/sr_run.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'     ${util_path}/sr_run.sh
sed -i 's/@db_data_path@/'${db_data_path_template}'/g'   ${util_path}/sr_run.sh
sed -i 's/@db_kslib_path@/'${db_kslib_path_template}'/g' ${util_path}/sr_run.sh

#----------------------  sr_run_cluster.sh.t -------------------------------------------

cp ${dks_inst_path}/template/sr_run_cluster.sh.t         ${util_path}/sr_run_cluster.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/sr_run_cluster.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/sr_run_cluster.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'     ${util_path}/sr_run_cluster.sh
sed -i 's/@db_data_path@/'${db_data_path_template}'/g'   ${util_path}/sr_run_cluster.sh

#----------------------  sr_switchover_standby.sh --------------------------------------

cp ${dks_inst_path}/template/sr_switchover_standby.sh.t  ${util_path}/sr_switchover_standby.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/sr_switchover_standby.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/sr_switchover_standby.sh
sed -i 's/@db_port@/'${db_port}'/g'                      ${util_path}/sr_switchover_standby.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'     ${util_path}/sr_switchover_standby.sh
sed -i 's/@db_data_path@/'${db_data_path_template}'/g'   ${util_path}/sr_switchover_standby.sh
sed -i 's/@db_kslib_path@/'${db_kslib_path_template}'/g' ${util_path}/sr_switchover_standby.sh

#----------------------  sr_unregistr_standby.sh ---------------------------------------

cp ${dks_inst_path}/template/sr_unregister_standby.sh.t  ${util_path}/sr_unregister_standby.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/sr_unregister_standby.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/sr_unregister_standby.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'     ${util_path}/sr_unregister_standby.sh

#----------------------  sr_unregistr_witness.sh ---------------------------------------

cp ${dks_inst_path}/template/sr_unregister_witness.sh.t  ${util_path}/sr_unregister_witness.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/sr_unregister_witness.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/sr_unregister_witness.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'     ${util_path}/sr_unregister_witness.sh

#----------------------  sr_unregister_primary.sh ---------------------------------------

cp ${dks_inst_path}/template/sr_unregister_primary.sh.t  ${util_path}/sr_unregister_primary.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/sr_unregister_primary.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/sr_unregister_primary.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'     ${util_path}/sr_unregister_primary.sh


#----------------------  sr_set_ssh.sh -------------------------------------------------

cp ${dks_inst_path}/template/sr_set_ssh.sh.t             ${util_path}/sr_set_ssh.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                    ${util_path}/sr_set_ssh.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                      ${util_path}/sr_set_ssh.sh
sed -i 's/@db_port@/'${db_port}'/g'                      ${util_path}/sr_set_ssh.sh
sed -i 's/@db_data_path@/'${db_data_path_template}'/g'   ${util_path}/sr_set_ssh.sh


chmod 777 ${util_path}/sr*.sh

exit;



