#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

dks_init_var_file=$1

#------------------- Переменные ----------------------------------------
tag_ver=$($dks_bashfile_dir/dks_const_var.sh           tag_ver)
tag_year=$($dks_bashfile_dir/dks_const_var.sh          tag_year)
db_bin_path=$($dks_bashfile_dir/dks_const_var.sh       db_bin_path)
db_lib_path=$($dks_bashfile_dir/dks_const_var.sh       db_lib_path)
db_kslib_path=$($dks_bashfile_dir/dks_const_var.sh     db_kslib_path)
dks_inst_path=$($dks_bashfile_dir/dks_const_var.sh     dks_inst_path)

dks_cont_name=$($dks_bashfile_dir/${dks_init_var_file} dks_cont_name)
dks_serv_name=$($dks_bashfile_dir/${dks_init_var_file} dks_serv_name)

tag_name=$($dks_bashfile_dir/${dks_init_var_file}      tag_name)
db_port=$($dks_bashfile_dir/${dks_init_var_file}       db_port)
db_data_path=$($dks_bashfile_dir/${dks_init_var_file}  db_data_path)
contsoft=$($dks_bashfile_dir/${dks_init_var_file}      contsoft)


# экранируем символ слеш пути, т.к.возникает  ошибка при использовании sed
db_bin_path_template=$(echo "${db_bin_path}"| sed 's/\//\\\//g')
db_kslib_path_template=$(echo "${db_kslib_path}"| sed 's/\//\\\//g')
db_data_path_template=$(echo "${db_data_path}"| sed 's/\//\\\//g')

net_access=$($dks_bashfile_dir/dks_const_var.sh net_access)
net_access_search=$($dks_bashfile_dir/dks_const_var.sh net_access_search)
net_dbo_access=$($dks_bashfile_dir/dks_const_var.sh net_dbo_access)


#-----------------------------------------------------------------------

function fn_file_clr(){
cat > $1 << EOF
EOF
}


# Корректируем права доступа на каталог данных кластера внутри контейнера

bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "chown -R postgres:postgres ${db_data_path}" -noout

# Вычисляем timezone хоста, для установки в pgsqlks.conf
tz_host=$(date +%:::z)  # результат в формате типа "+03" (например, часовой пояс для  Europe/Moscow)
tz_pgsql=${tz_host//+/} # выпиливаем символ "+"

#----------------------- pgsqlks.conf -----------------------------------
if [ -f "${db_data_path}/data/conf.d/pgsqlks.conf" ]; then
  fn_file_clr ${db_data_path}/data/conf.d/pgsqlks.conf
fi

cat > ${db_data_path}/data/conf.d/pgsqlks.conf << EOF
# Порт и адреса
listen_addresses = '*'                # what IP address(es) to listen on;
port = ${db_port}                     # (change requires restart)
jit = off                             # disable JIT compilation
#timezone = 'GMT-${tz_pgsql}'

search_path = '"\$user", dbo, public' # schema name

password_encryption = md5
max_connections = 300
shared_buffers = 1024MB
work_mem = 16MB
maintenance_work_mem = 128MB
max_locks_per_transaction = 300

logging_collector = on
log_filename = 'pgsqlks_log.%a'
log_truncate_on_rotation = on
log_rotation_age = 1440

# Каталоги для libxpks.so и служебных скриптов
ks.libdir='${db_lib_path}'
ks.bindir='${db_bin_path}'

shared_preload_libraries='pg_stat_statements,repmgr'

#pg_stat_statements.max = 100000
#pg_stat_statements.track = all
#pg_stat_statements.track=none

EOF

# ---------------------- pg_hba.conf --------------------------------------
if [ -z "$(grep -E ${net_access_search} ${db_data_path}/data/pg_hba.conf)" ]; then
cat << EOF >> ${db_data_path}/data/pg_hba.conf

#${db_inst_name}
${net_dbo_access}

#${db_inst_name}
${net_access}

EOF
fi;


# Удаляем файл, если контейнер был удален без остановки сервера
if [ -f "${db_data_path}/data/postmaster.pid" ]; then
  rm -f ${db_data_path}/data/postmaster.pid
fi;

if [ -f "/tmp/.s.PGSQL.${db_port}" ]; then
  rm -f /tmp/.s.PGSQL.${db_port}
fi;

# Создаем каталог для бэкапов
mkdir -p ${db_data_path}/backups
chown -R ks-postgres:ks-postgres ${db_data_path}/backups

# Создаем каталог хранения доверенных сертификатов,
# монтирование в контейнер /etc/ssl/certs
mkdir -p ${db_data_path}/ssl
mkdir -p ${db_data_path}/ssl/certs
chown -R ks-postgres:ks-postgres ${db_data_path}/ssl

# Создаем каталог .ssh, для настройки ssh соединений,
# монтирование в контейнер /home/postgres/.ssh
mkdir -p ${db_data_path}/.ssh
chown -R ks-postgres:ks-postgres ${db_data_path}/.ssh


# Создаем каталог для скриптов управления репликацией
mkdir -p ${db_data_path}/sr_ctl
mkdir -p ${db_data_path}/sr_ctl/sql

#----------------------  psr_repmgrd.sh -----------------------------------------------

cp ${dks_inst_path}/template/psr_repmgrd.sh.t         ${db_data_path}/sr_ctl/psr_repmgrd.sh
sed -i 's/@tag_year@/'${tag_year}'/g'                 ${db_data_path}/sr_ctl/psr_repmgrd.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'                   ${db_data_path}/sr_ctl/psr_repmgrd.sh
sed -i 's/@db_bin_path@/'${db_bin_path_template}'/g'  ${db_data_path}/sr_ctl/psr_repmgrd.sh

#----------------------   dks_sr_funcs.sql --------------------------------------------
cp ${dks_inst_path}/sql/dks_sr_funcs.sql              ${db_data_path}/sr_ctl/sql/dks_sr_funcs.sql

chown -R ks-postgres:ks-postgres ${db_data_path}/sr_ctl
chmod -R 777 ${db_data_path}/sr_ctl
chmod 644 ${db_data_path}/sr_ctl/sql/*.sql

# помещаем файл информатор, если по контейнеризации podman
rm -f ${db_data_path}/podman
if [ "${contsoft}" = "podman" ]; then
  echo "podman" > ${db_data_path}/podman
  chown ks-postgres:ks-postgres ${db_data_path}/podman
fi;

exit;



