#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# Контейнер
dks_inst_path=$($dks_bashfile_dir/dks_const_var.sh dks_inst_path)
tag_ver=$($dks_bashfile_dir/dks_const_var.sh       tag_ver)
tag_year=$($dks_bashfile_dir/dks_const_var.sh      tag_year)

db_port_for_gen=$1
db_pwd_for_gen=$(echo $2 | sed "s/'/''/g")
db_pwd_for_gen=$(echo ${db_pwd_for_gen} | sed 's/"/\\"/g')

if [ -z "$1" ]; then
  exit 1;
fi;

if [ -z "$2" ]; then
  contsoft="docker"
else
  contsoft=$2
fi;

if [ -z "$3" ]; then
  db_pwd_for_gen="1"
else
  db_pwd_for_gen=$3
fi;

typeOS=$4

#Dockerfile
cp ${dks_inst_path}/template/Dockerfile.t      ${dks_inst_path}/container_image/Dockerfile
sed -i 's/@tag_year@/'${tag_year}'/g'          ${dks_inst_path}/container_image/Dockerfile
sed -i 's/@tag_ver@/'${tag_ver}'/g'            ${dks_inst_path}/container_image/Dockerfile
sed -i 's/@db_port@/'${db_port_for_gen}'/g'    ${dks_inst_path}/container_image/Dockerfile

cp ${dks_inst_path}/template/dks_init_var.t    ${dks_bashfile_dir}/dks_init_var_${db_port_for_gen}.sh
sed -i 's/@tag_year@/'${tag_year}'/g'          ${dks_bashfile_dir}/dks_init_var_${db_port_for_gen}.sh
sed -i 's/@tag_ver@/'${tag_ver}'/g'            ${dks_bashfile_dir}/dks_init_var_${db_port_for_gen}.sh
sed -i 's/@db_port@/'${db_port_for_gen}'/g'    ${dks_bashfile_dir}/dks_init_var_${db_port_for_gen}.sh
sed -i 's/@db_pwd@/'${db_pwd_for_gen}'/g'      ${dks_bashfile_dir}/dks_init_var_${db_port_for_gen}.sh
sed -i 's/@typeOS@/'${typeOS}'/g'              ${dks_bashfile_dir}/dks_init_var_${db_port_for_gen}.sh

sed -i 's/@contsoft@/'${contsoft}'/g'          ${dks_bashfile_dir}/dks_init_var_${db_port_for_gen}.sh

chmod 755 ${dks_bashfile_dir}/dks_init_var_${db_port_for_gen}.sh

exit 0;

