#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

#============== Основные переменные =====================

# Цвета
ErrColor=$(${dks_bashfile_dir}/dks_const_var.sh ErrColor)
SuccColor=$(${dks_bashfile_dir}/dks_const_var.sh SuccColor)
WarnColor=$(${dks_bashfile_dir}/dks_const_var.sh WarnColor)
NoColor=$(${dks_bashfile_dir}/dks_const_var.sh NoColor)
eRR=$(echo $(${dks_bashfile_dir}/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $(${dks_bashfile_dir}/dks_const_var.sh emptE) | tr '#' ' ')

# sudo
bash ${dks_bashfile_dir}/sys/sys_is_root.sh "run"
if [ $? = "1" ]; then exit 1; fi;

function fn_file_clr(){
cat > $1 << EOF
EOF
}
#==========================================================

db_port=$1
# если параметр не передан, то показываем обобщенную инфомацию
if [ -z "${db_port}" ]; then

  echo ""
  echo -e "${WarnColor}Существующие контейнеры${NoColor}"
  echo "~~~~~~~~~~~~~~~~~~~~~~~~"
  docker_exists=$(which docker 2>/dev/null)
  if [ ! -z ${docker_exists} ]; then
    echo -e "${WarnColor}Docker:${NoColor}"
    docker ps -a | grep "pgsqlks\|CONTAINER ID"
  fi;
  podman_exists=$(which podman 2>/dev/null)
  if [ ! -z ${podman_exists} ]; then
    echo -e "${WarnColor}Podman:${NoColor}"
    podman ps -a | grep "pgsqlks\|CONTAINER ID"
  fi;


  echo ""
  echo -e "${WarnColor}Существующие образы контейнеров${NoColor}"
  echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
  docker_exists=$(which docker 2>/dev/null)
  if [ ! -z ${docker_exists} ]; then
    echo -e "${WarnColor}Docker:${NoColor}"
    docker images | grep "pgsqlks\|IMAGE ID"
  fi;
  podman_exists=$(which podman 2>/dev/null)
  if [ ! -z ${podman_exists} ]; then
    echo -e "${WarnColor}Podman:${NoColor}"
    podman ps -a | grep "pgsqlks\|CONTAINER ID"
  fi;

  echo ""
  echo -e "${WarnColor}Процессы контейнеров, транслируемые на хост:${NoColor}"
  echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
  ps -ef | grep -v root | grep "/opt/pgsqlks\|UID\|ssh"

  echo ""
  echo -e "${WarnColor}Сервисы systemd:${NoColor}"
  echo -e "~~~~~~~~~~~~~~~~"
  systemctl list-units pgsqlks* | grep "UNIT\|pgsqlks" | grep -v "not-found"

  echo ""
  exit 0;
fi;

dks_init_var_file="dks_init_var_${db_port}.sh"


# Проверка файла переменных по переданному порту
if  [ ! -f "${dks_bashfile_dir}/${dks_init_var_file}" ]; then
  echo -e ""
  echo -e "${eRR}Отсутствует файл инициализации переменных ${dks_bashfile_dir}/${dks_init_var_file}."
  echo -e "${emptE}Возможно, что контейнер с указанным портом \"${db_port}\" не создавался."
  echo -e ""
  exit 1;
fi;


# Контейнер (считываем наименование контейнера и сервиса)
dks_cont_name=$(${dks_bashfile_dir}/${dks_init_var_file} dks_cont_name)
dks_serv_name=$(${dks_bashfile_dir}/${dks_init_var_file} dks_serv_name)
contsoft=$(${dks_bashfile_dir}/${dks_init_var_file} contsoft)

# Файл обмена
dks_stdout=$(${dks_bashfile_dir}/${dks_init_var_file} dks_stdout)
dks_stdout_cont=$(${dks_bashfile_dir}/${dks_init_var_file} dks_stdout_cont)

fn_file_clr ${dks_stdout}
chmod 777 ${dks_stdout}


echo ""

if [ ! -f "/lib/systemd/system/${dks_serv_name}" ]; then
  echo -e "${ErrColor}Сервис ${dks_serv_name} отсутствует в системе.${NoColor}"
else
  echo -e "${WarnColor}Сервис ${dks_serv_name}:${NoColor}"
  echo -e "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
  systemctl status ${dks_serv_name} --no-pager
fi;


echo ""

# Проверяем существование контейнера
dks_exists=$(${contsoft} container ls -a | grep ${dks_cont_name})
if [ -z "$dks_exists" ]; then
  echo -e "${ErrColor}Контейнера ${dks_cont_name} не существует.${NoColor}"
  echo ""
  exit;
fi;

# Определяем запущен ли контейнера
dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

if [ "${dks_status}" = "false" ]; then
  echo -e "${ErrColor}Контейнер ${dks_cont_name} не запущен.${NoColor}"
  echo ""
  exit;
fi;


echo ""
echo -e "${WarnColor}Свойства контейнера ${dks_cont_name}:${NoColor}"
echo -e "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "echo 'Дата : $(date)'"
bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "echo 'Часовой пояс : $(date +%Z%:::z)'"

echo ""
echo -e "${WarnColor}Процессы контейнера ${dks_cont_name} (за исключением запущенных под root):${NoColor}"
echo -e "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "ps -efl | grep -v root"

rm -f ${dks_stdout}

echo ""

exit;



