#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

param_in=$1

#============== Основные определяющие переменные ========
tag_ver="14.13"
tag_name="pgsqlks-"${tag_ver}
tag_year="2024"
#========================================================


# Контейнер
dks_inst_name="dks-${tag_name}"
dks_inst_path="/opt/${dks_inst_name}"

# СУБД
db_inst_name=${tag_name}
db_bin_path="/opt/${db_inst_name}/bin"
db_lib_path="/opt/${db_inst_name}/lib"
db_kslib_path="${db_lib_path}/kslib"

repmgr_path="/opt/${tag_name}/repmgr"
util_path="/opt/${tag_name}/utility"

# Переменные константы
net_access='host all all 0.0.0.0/0 md5'
net_access_search='host.all.all.[0]\.[0]\.[0]\.[0]/[0].md5'
net_dbo_access="host all dbo 127.0.0.1/32 trust"

# Цвета
ErrColor='\033[1;31m'
SuccColor='\033[0;32m'
WarnColor='\033[0;33m'
NoColor='\033[0m'

sOK="[###${SuccColor}OK${NoColor}###]#"
wOK="[##${WarnColor}Инфо${NoColor}##]#"
eRR="[#${ErrColor}Ошибка${NoColor}#]#"
emptE="###########"

# sudo
is_root=$EUID
#==========================================================



case ${param_in} in
      tag_ver)
          param_out=${tag_ver}
          ;;
      tag_name)
          param_out=${tag_name}
          ;;
      tag_year)
          param_out=${tag_year}
          ;;


      dks_inst_name)
          param_out=${dks_inst_name}
          ;;
      dks_inst_path)
          param_out=${dks_inst_path}
          ;;
      dks_cont_name)
          param_out=${dks_cont_name}
          ;;
      dks_serv_name)
          param_out=${dks_serv_name}
          ;;

      repmgr_path)
          param_out=${repmgr_path}
          ;;
      util_path)
          param_out=${util_path}
          ;;


      db_inst_name)
          param_out=${db_inst_name}
          ;;
      db_bin_path)
          param_out=${db_bin_path}
          ;;
      db_lib_path)
          param_out=${db_lib_path}
          ;;
      db_kslib_path)
          param_out=${db_kslib_path}
          ;;
      db_data_path)
          param_out=${db_data_path}
          ;;
      db_port)
          param_out=${db_port}
          ;;
      db_pwd)
          param_out=${db_pwd}
          ;;

      net_access)
          param_out=${net_access}
          ;;
      net_access_search)
          param_out=${net_access_search}
          ;;
      net_dbo_access)
          param_out=${net_dbo_access}
          ;;

      ErrColor)
          param_out=${ErrColor}
          ;;
      SuccColor)
          param_out=${SuccColor}
          ;;
      WarnColor)
          param_out=${WarnColor}
          ;;
      NoColor)
          param_out=${NoColor}
          ;;

      sOK)
          param_out=${sOK}
          ;;
      wOK)
          param_out=${wOK}
          ;;
      eRR)
          param_out=${eRR}
          ;;
      emptE)
          param_out=${emptE}
          ;;


      is_root)
          param_out=${is_root}
          ;;

     *)
          param_out="Неизвестный параметр ${param_in}."
          ;;
esac

echo ${param_out}

exit;
