#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"


while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -p|--port)
        port="$2"
        ;;
      -pwd|--password)
        password="$2"
        ;;
      -shm|--shm_size)
        shm_size="$2"
        ;;
      -l|--locale)
        locale="$2"
        ;;
      -cs|--contsoft)
        contsoft="$2"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -p  | --port           5434           порт СУБД

 -pwd| --password       1              пароль, который присваивается суперпользователям СУБД dbo и postgres

 -l  | --locale         ru_RU.utf8     локаль для инициализации кластера СУБД

 -shm| --shm_size       256            размер shared memory при создании контейнера в MB

 -cs | --contsoft       docker         ПО контейнерезации (docker или podman)

"
exit 1;
fi;

if [ -z "${port}" ]; then
  port="5434"
fi;

if [ -z "${password}" ]; then
  password="1"
fi;

if [ -z "${shm_size}" ]; then
  shm_size="256"
fi;

if [ -z "${locale}" ]; then
  locale="ru_RU.utf8"
fi;

if [ -z "${contsoft}" ]; then
  contsoft="docker"
fi;

if [ ! ${contsoft} = "docker" ]; then
  contsoft="podman"
fi;


echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~   Установка контейнера СУБД-КС 14.13     "
echo "           ~              порт : ${port}              "
echo "           ~   контейнеризация : ${contsoft}          "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

bash ${dks_bashfile_dir}/sh/dks_create.sh "${port}"      \
                                          "${password}"  \
                                          "${shm_size}"  \
                                          "${locale}"    \
                                          "${contsoft}"

exit;

