#!/bin/bash

##
## Платформа для установки и развертывания ПО контейнерезации
## Docker-CE (Docker Engine - Community)
##

mode=$1

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -f|--force)
        mode="force"
        ;;
      -q|--quiet)
        quiet="1"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -f  | --force                         принудительное удаление, без проверки существующих 
                                       контейнеров и образов
 -q  | --quiet                         выполнение операции удаления без подтверждения
"
exit 1;
fi;



WarnColor='\033[0;33m'
NoColor='\033[0m'
uQY="[ ${WarnColor}Запрос${NoColor} ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~    Удаление Docker-CE 20.10.11   ~"
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"


if [ -z "${quiet}" ]; then
  echo ""
  echo -n -e "${uQY}Вы действительно хотите удалить Docker-CE?
           ([да;y]/[нет;n]): "

  read item
  case "$item" in
    y|Y|да)
        ;;
    n|N|нет) echo -e "${emptE}Операция удаления прервана."; echo "";
        exit;
        ;;
    *) echo -e "${emptE}Операция удаления прервана."; echo "";
        exit;
        ;;
  esac
fi;

bash ${dks_bashfile_dir}/sh/dks_file_remove.sh "${mode}"

exit 1;
