#!/bin/bash

##
## Платформа для установки и развертывания ПО контейнерезации
## Docker-CE (Docker Engine - Community)
##

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

mode=$1

# Цвета
ErrColor='\033[1;31m'
SuccColor='\033[0;32m'
WarnColor='\033[0;33m'
NoColor='\033[0m'

sOK="[   ${SuccColor}OK${NoColor}   ] "
wOK="[  ${WarnColor}Инфо${NoColor}  ] "
eRR="[ ${ErrColor}Ошибка${NoColor} ] "
emptE="           "


echo ""

# Проверка прав суперпользователя
if [ "$EUID" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  echo -e "${emptE}Операция удаления докера будет прервана."
  exit 1;
fi


# Если не включен режим принудительного удаления, то проверяем наличие контейнеров
if [ ! "${mode}" = "force" ]; then

  echo -e "${sOK}Запуск удаления."

  # Проверка ранее установленного.
  if [ -f "/lib/systemd/system/docker.service" ]; then
    echo -e "${sOK}Обнаружение сервиса докера - docker.service."
    if systemctl -q is-active docker; then
      echo -e "${emptE}Проверка статуса сервиса докера - docker.service."
    else
      echo -e "${emptE}Запуск сервиса докера - docker.service."
      systemctl start docker.service
    fi;

    exists_cont=""
    exists_cont=$(docker ps -a | grep -v "CONTAINER ID")

    if [ ! -z "${exists_cont}" ]; then
      echo -e "${eRR}Проверка отсутствия контейнеров в докере."
      echo -e "${emptE}В докере обнаружены контейнеры. Операция удаления докера будет отменена."
      echo -e "${emptE}Для удаления контейнеров используйте команду: docker rm <id conteiner>."
      echo -e "${emptE}Для получения списка контейнеров используйте команду: docker ps -a"
      exit 1;
    else
      echo -e "${sOK}Проверка отсутствия контейнеров в докере."
    fi;
  fi;
else
  echo -e "${sOK}Запуск принудительного удаления."
fi;

if systemctl -q is-active docker; then
  echo -e "${emptE}Остановка сервиса докера (docker.service)."
  systemctl stop docker.service
fi;
rm -f /lib/systemd/system/docker.service
echo -e "${sOK}Удаление сервиса докера - docker.service."

installdir="/usr/bin"

echo -e "${sOK}Удаление бинарных файлов из каталога ${installdir}"

if [ -f "${installdir}/containerd" ]; then
  rm -f ${installdir}/containerd
  echo -e "${emptE}- containerd"
fi;

if [ -f "${installdir}/containerd-shim" ]; then
  rm -f ${installdir}/containerd-shim
  echo -e "${emptE}- containerd-shim"
fi;

if [ -f "${installdir}/containerd-shim-runc-v2" ]; then
  rm -f ${installdir}/containerd-shim-runc-v2
  echo -e "${emptE}- containerd-shim-runc-v2"
fi;

if [ -f "${installdir}/ctr" ]; then
  rm -f ${installdir}/ctr
  echo -e "${emptE}- ctr"
fi;

if [ -f "${installdir}/docker" ]; then
  rm -f ${installdir}/docker
  echo -e "${emptE}- docker"
fi;

if [ -f "${installdir}/docker.sh" ]; then
  rm -f ${installdir}/docker.sh
  echo -e "${emptE}- docker.sh"
fi;

if [ -f "${installdir}/docker-init" ]; then
  rm -f ${installdir}/docker-init
  echo -e "${emptE}- docker-init"
fi;

if [ -f "${installdir}/docker-proxy" ]; then
  rm -f ${installdir}/docker-proxy
  echo -e "${emptE}- docker-proxy"
fi;

if [ -f "${installdir}/dockerd" ]; then
  rm -f ${installdir}/dockerd
  echo -e "${emptE}- dockerd"
fi;

if [ -f "${installdir}/runc" ]; then
  rm -f ${installdir}/runc
  echo -e "${emptE}- runc"
fi;

echo ""
exit 0;

