#!/bin/bash

##
## Платформа для установки и развертывания ПО контейнерезации
## Docker-CE (Docker Engine - Community)
##


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# arhive with binary
filearh=$1
# --bip string  Specify network bridge IP
bip=$2

# Цвета
ErrColor='\033[1;31m'
SuccColor='\033[0;32m'
WarnColor='\033[0;33m'
NoColor='\033[0m'

sOK="[   ${SuccColor}OK${NoColor}   ] "
wOK="[  ${WarnColor}Инфо${NoColor}  ] "
eRR="[ ${ErrColor}Ошибка${NoColor} ] "
emptE="           "
emptEsh="###########"
tmp_stdout="tmp.stdout"
echo ""

function fn_file_clr(){
cat > $1 << EOF
EOF
}

function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
 done
}


installdir="/usr/bin"

set_ip_bridge=""
if ! [ -z "${bip}" ]; then
  set_ip_bridge=$(echo "${bip}" | grep -Eo "\b([0-9]{1,3}\.){3}[0-9]{1,3}\b")

  if [ -z "${set_ip_bridge}" ]; then
    echo -e "${eRR}Проверка формата ip адреса параметра - docker network"
    echo -e "${emptE}Указанное значение не соответствует формату ip адреса."
    echo -e "${emptE}Операция развертывания будет прервана."
    exit 1;
  else
    set_ip_bridge="--bip ${bip}"
  fi;
fi;



# Проверяем, что файл архива есть
if [ ! -f "${dks_bashfile_dir}/${filearh}" ]; then
  echo -e "${eRR}Отсутствует файл архива ${filearh}."
  echo -e "${emptE}Операция развертывания будет прервана."
  echo -e ""
  exit 1;
fi

# Проверка прав суперпользователя
if [ "$EUID" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  echo -e "${emptE}Операция развертывания будет прервана."
  exit 1;
fi

# Проверка наличия архиватора
if ! [ -f "/usr/bin/tar" ] && ! [ -f "/bin/tar" ] ; then
  echo -e "${eRR}Проверка наличия архиватора tar."
  echo -e "${emptE}В системе отсутствует архиватор tar."
  echo -e "${emptE}Операция развертывания будет прервана."
  exit 1;
fi;

#iptables --help &>/dev/nul;echo $?;
if ! [ -f "/usr/bin/iptables" ] && ! [ -f "/bin/iptables" ] && ! [ -f "/usr/sbin/iptables" ]; then
  echo -e "${eRR}Проверка наличия iptables."
  echo -e "${emptE}В системе отсутствует iptables."
  echo -e "${emptE}Операция развертывания будет прервана."
  exit 1;
fi;


# Проверка, что файл уже есть в /usr/bin/
if [ -f "${installdir}/docker" ]; then
  echo -e "${eRR}Обнаружен исполняемый файл докера ${installdir}/docker"
  echo -e "${emptE}$(docker -v)"
  echo -e "${emptE}Возможно докер был уже установлен."
  echo -e "${emptE}Операция развертывания будет прервана."
  echo ""
  exit 1;
fi;

# Проверка ранее установленного.
if [ -f "/lib/systemd/system/docker.service" ]; then
  echo -e "${eRR}Обнаружен сервис докера (docker.service)."
  echo -e "${emptE}Возможно докер был уже установлен."
  echo -e "${emptE}Операция развертывания будет прервана."
  echo ""
  exit 1;
fi;


se_mode="Disabled"
# Проверка Selinux
if [ -f /etc/selinux/config ]; then
  se_mode=$(echo $(getenforce))
  if [ "${se_mode}" = "Enforcing" ]; then
    # переключаем в разрешительный :)
    setenforce Permissive
  fi;
fi;

# временный катлог дла работы
tmpdir="${dks_bashfile_dir}/tmp_dks_install"
rm -R -f ${tmpdir}
mkdir -p ${tmpdir}


# Создание группы docker
echo -e "${sOK}Проверка/Создание группы docker."
fn_file_clr ${tmpdir}/${tmp_stdout}
fn_file_echo ${tmpdir}/${tmp_stdout} ${emptEsh}
groupadd docker >/dev/null 2>${tmpdir}/${tmp_stdout}
#показываем
fn_file_echo ${tmpdir}/${tmp_stdout} ${emptEsh}
fn_file_clr ${tmpdir}/${tmp_stdout}


# распаковываем архив
tar zxf ${dks_bashfile_dir}/${filearh} -C ${tmpdir} --strip-components 1
echo -e "${sOK}Распаковка архива ${filearh}."


# копируем всё в /usr/bin
cp -r ${tmpdir}/. ${installdir}
echo -e "${sOK}Копирование бинарных файлов в каталог ${installdir}/."

# создаем файл сервиса
cat > /lib/systemd/system/docker.service << EOF
[Unit]
Description=Docker Application Container Engine (Binary install)
After=syslog.target
After=network.target

[Service]
Type=notify
# the default is not to use systemd for cgroups because the delegate issues still
# exists and systemd currently does not support the cgroup feature set required
# for containers run by docker
ExecStart=/usr/bin/dockerd ${set_ip_bridge}
ExecReload=/bin/kill -s HUP \$MAINPID
TimeoutSec=0
RestartSec=2
Restart=always

# Note that StartLimit* options were moved from "Service" to "Unit" in systemd 229.
# Both the old, and new location are accepted by systemd 229 and up, so using the old location
# to make them work for either version of systemd.
StartLimitBurst=3

# Note that StartLimitInterval was renamed to StartLimitIntervalSec in systemd 230.
# Both the old, and new name are accepted by systemd 230 and up, so using the old name to make
# this option work for either version of systemd.
StartLimitInterval=60s

# Having non-zero Limit*s causes performance problems due to accounting overhead
# in the kernel. We recommend using cgroups to do container-local accounting.
LimitNOFILE=infinity
LimitNPROC=infinity
LimitCORE=infinity

# Comment TasksMax if your systemd version does not supports it.
# Only systemd 226 and above support this option.
TasksMax=infinity

# set delegate yes so that systemd does not reset the cgroups of docker containers
Delegate=yes

# kill only the docker process, not all processes in the cgroup
KillMode=process

[Install]
WantedBy=multi-user.target
EOF

echo -e "${sOK}Создание файла сервиса docker.service."


# стартуем сервис
systemctl daemon-reload
systemctl start docker.service

systemctl enable docker.service >/dev/null 2>${tmpdir}/${tmp_stdout}
fn_file_echo "${tmpdir}/${tmp_stdout}" ${emptEsh}

# стартуем сервис
#systemctl start docker.service

# удаляем временный каталог, куда распаковывали файлы
rm -R -f ${tmpdir}

# Проверяем что служба запустилась
if systemctl -q is-active docker.service; then
  echo -e "${sOK}Запуск сервиса docker.service."
else
  echo -e "${eRR}Запуск сервиса docker.service."
  echo -e "${emptE}Была предпринята неудачная попытка запуска сервиса docker.service."
  echo -e "${emptE}Если сервис не будет запущен, то docker.service не запустится после перезагрузки хоста."
  echo -e "${emptE}Обязательно свяжитесь со свои системным администратором."
fi;


# восстанавливаем значение для selinux
if [ "${se_mode}" = "Enforcing" ]; then
  # переключаем обратно.
  setenforce Enforcing
fi;

echo ""
exit 0;

