#!/bin/bash

##
## Платформа для установки и развертывания ПО контейнерезации
## Docker-CE (Docker Engine - Community)
##

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -bip|--bip)
        bip="$2"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -bip  | --bip                         bridge network docker

"
exit 1;
fi;


echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~    Установка Docker-CE 20.10.11   ~"
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

bash ${dks_bashfile_dir}/sh/dks_file_install.sh "docker-20.10.11.tgz" "${bip}"

exit;



