#!/bin/bash

##
## Платформа для установки и развертывания ПО контейнерезации
## Docker-CE (Docker Engine - Community)
##


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# Цвета
ErrColor='\033[1;31m'
SuccColor='\033[0;32m'
WarnColor='\033[0;33m'
NoColor='\033[0m'

installdir="/usr/bin"
echo ""

if [ -f "${installdir}/docker" ]; then
  echo -e "${WarnColor}Версия установленного ПО Docker:${NoColor}"
  echo ""
  docker version
  echo ""
  systemctl -l -n 1 status docker
else
  echo -e "${ErrColor}ПО Docker не установлено.${NoColor}"
fi;


echo ""

exit;

