Ext.define("KSWN.admin.login.model.Profile",{extend:"Ext.data.Model",proxy:{type:"indexeddb",dbName:"ks-admin-login-profiles"},identifier:"uuid",fields:[{name:"name",type:"string"},{name:"login",type:"string"},{name:"dbType",type:"int"},{name:"dbName",type:"string"},{name:"dbServer",type:"string"},{name:"isDefault",type:"bool",defaultValue:!1}],getLoginParams:function(){const{login:login,dbType:dbType,dbName:dbName,dbServer:dbServer}=this.data;return{login:login,dbType:dbType,dbName:dbName,dbServer:dbServer}},getEditData:function(){return{name:this.getName(),...this.getLoginParams()}},getName:function(){return this.data.name},isDefault:function(){return this.data.isDefault}}),Ext.define("KSWN.admin.login.store.Profiles",{extend:"Ext.data.Store",alias:"store.ks-admin-login-profiles",model:"KSWN.admin.login.model.Profile"}),Ext.define("KSWN.admin.login.view.ProfilesEditWin",{extend:"Ext.window.Window",xtype:"ks-admin-login-profileseditwin",title:KSWN.Locale.redaktirovanie,iconCls:KSWN.Constant.iconClsPrefix+"settings",layout:"fit",width:568,height:348,bodyPadding:4,modal:!0,items:{xtype:"panel",layout:{type:"hbox",align:"stretch"},tbar:[{iconCls:KSWN.Constant.iconClsPrefix+"copy",tooltip:KSWN.Locale.kopirovat,handler:"onProfileEditCopyBtnClick",bind:{disabled:"{!selectedEditProfile}"}},{iconCls:KSWN.Constant.iconClsPrefix+"delete",tooltip:KSWN.Locale.udalit,handler:"onProfileEditDeleteBtnClick",bind:{disabled:"{!selectedEditProfile}"}}],items:[{xtype:"grid",border:1,flex:1,columns:[{dataIndex:"name",text:KSWN.Locale.profil,flex:1}],bind:{store:"{profilesEditStore}",selection:"{selectedEditProfile}"}},{xtype:"splitter"},{xtype:"propertygrid",border:1,flex:2,reference:"profilePropertyGrid",sortableColumns:!1,listeners:{beforepropertychange:"onBeforeProfileEditPropertyChange",propertychange:"onProfileEditPropertyChange"},sourceConfig:{name:{displayName:KSWN.Locale.imya},login:{displayName:KSWN.Locale.login},dbType:{displayName:KSWN.Locale.tipsubd,renderer:value=>KSWN.system.DataSourceType.getName(value),editor:new KSWN.ux.field.DefaultCombobox({editable:!1,displayField:"name",valueField:"value",bind:{store:"{dataSourceTypesStore}"}})},dbServer:{displayName:KSWN.Locale.server},dbName:{displayName:KSWN.Locale.bazadannikh}}}]}}),Ext.define("KSWN.admin.login.view.LoginCPForm",{extend:"Ext.form.Panel",xtype:"ks-admin-login-view-logincpform",title:KSWN.Locale.konfigurator,layout:"anchor",defaults:{labelWidth:100,width:"100%"},defaultType:"textfield",defaultButton:"submitCPFormBtn",items:[{fieldLabel:KSWN.Locale.login,reference:"form",name:"login",allowBlank:!1,tabIndex:1,bind:{value:"{CPLogin}"}},{fieldLabel:KSWN.Locale.parol,name:"password",inputType:"password",allowBlank:!1,tabIndex:2,bind:{value:"{CPPassword}"}}],buttons:[{xtype:"button",text:KSWN.Locale.voiti,reference:"submitCPFormBtn",ui:"main-button-ks",cls:"ks-login-btn",formBind:!0,scale:"large",iconCls:"ks-login-btn-icon",handler:"onLoginCPFormSubmitBtnClick"}]}),Ext.define("KSWN.admin.login.view.LoginDBForm",{extend:"Ext.form.Panel",xtype:"ks-admin-login-view-logindbform",title:KSWN.Locale.vkhodvkompleks,layout:"anchor",defaults:{labelWidth:100,width:"100%"},defaultType:"textfield",defaultButton:"submitDBFormBtn",items:[{xtype:"container",layout:"hbox",items:[{xtype:"combo",fieldLabel:KSWN.Locale.profil,labelWidth:100,flex:1,displayField:"name",valueField:"id",queryMode:"local",reference:"profileCombobox",listeners:{select:"onProfileComboboxSelect"},bind:{store:"{profilesStore}",selection:"{selectedProfile}",value:"{profileComboboxValue}"}},{xtype:"button",iconCls:KSWN.Constant.iconClsPrefix+"settings",scale:"small",width:24,handler:"onProfilesSettingsBtnClick"}]},{xtype:"checkbox",boxLabel:KSWN.Locale.sokhranitprofil,hideEmptyLabel:!1,listeners:{disable:"onRememberProfileCheckboxDisable"},bind:{value:"{rememberProfile}",disabled:"{rememberProfileCheckboxDisabled}"}},{xtype:"component",margin:"0 0 8 0"},{fieldLabel:KSWN.Locale.login,allowBlank:!1,enableKeyEvents:!0,tabIndex:1,listeners:{paste:"onFormFieldPaste"},name:"login",bind:{value:"{login}"}},{fieldLabel:KSWN.Locale.parol,inputType:"password",enableKeyEvents:!0,tabIndex:2,listeners:{paste:"onFormFieldPaste"},name:"password",bind:"{password}"},{xtype:"combo",fieldLabel:KSWN.Locale.tipsubd,allowBlank:!1,editable:!1,displayField:"name",valueField:"value",tabIndex:3,listeners:{paste:"onFormFieldPaste"},name:"dbType",bind:{store:"{dataSourceTypesStore}",value:"{dbType}"}},{fieldLabel:KSWN.Locale.server,enableKeyEvents:!0,allowBlank:!1,tabIndex:4,listeners:{paste:"onFormFieldPaste"},name:"dbServer",bind:{value:"{dbServer}"}},{fieldLabel:KSWN.Locale.bazadannikh,enableKeyEvents:!0,allowBlank:!1,tabIndex:5,listeners:{paste:"onFormFieldPaste"},name:"dbName",bind:{value:"{dbName}"}},{xtype:"component",margin:"0 0 8 0"},{xtype:"checkbox",hideEmptyLabel:!1,boxLabel:"Использовать внешние источники (эксп.)"}],buttons:[{xtype:"button",text:KSWN.Locale.voiti,reference:"submitDBFormBtn",ui:"main-button-ks",cls:"ks-login-btn",formBind:!0,scale:"large",iconCls:"ks-login-btn-icon",tabIndex:6,handler:"onLoginDBFormSubmitBtnClick"}]}),Ext.define("KSWN.admin.login.view.ViewModel",{extend:"Ext.app.ViewModel",alias:"viewmodel.ks-admin-login",data:{rememberProfile:!1,selectedProfile:null,profileComboboxValue:null,login:null,password:null,dbType:KSWN.system.DataSourceType.MSSQL,dbName:null,dbServer:null,rememberProfileCheckboxDisabled:!1,CPLogin:null,CPPassword:null,selectedEditProfile:null},formulas:{rememberProfileCheckboxDisabled:{bind:{profile:"{selectedProfile}",profileComboboxValue:"{profileComboboxValue}"},get:function(_ref){let{profile:profile,profileComboboxValue:profileComboboxValue}=_ref;return profile?profile.isDefault()&&profile.getName()===profileComboboxValue:!profileComboboxValue}}},stores:{profilesStore:{type:"ks-admin-login-profiles"},profilesEditStore:{type:"chained",source:"{profilesStore}",filters:[rec=>!rec.isDefault()],sorters:[{property:"name",direction:"ASC"}]},dataSourceTypesStore:{data:KSWN.system.DataSourceType.getDataSourceTypesStoreData()}},getLoginParams:function(){const{login:login,password:password,dbName:dbName,dbServer:dbServer,dbType:dbType}=this.getData()},setLoginParams:function(_ref2){let{login:login,password:password,dbName:dbName,dbServer:dbServer,dbType:dbType}=_ref2;this.set({login:login,password:password,dbName:dbName,dbServer:dbServer,dbType:dbType})},setProfile:function(profile){this.set("selectedProfile",profile)},getProfilesStore:function(){return this.get("profilesStore")},getSelectedEditProfile:function(){return this.get("selectedEditProfile")},setSelectedEditProfile:function(selectedEditProfile){this.set({selectedEditProfile:selectedEditProfile})}}),Ext.define("KSWN.admin.login.view.ViewController",{extend:"Ext.app.ViewController",alias:"controller.ks-admin-login",bindings:{onProfileEditSelectionChange:"{selectedEditProfile}"},init:function(){this.initDefaultLoginParams()},initDefaultLoginParams:async function(){const vm=this.getViewModel(),adminLoginManager=this.getAdminLoginManager(),profileStore=vm.get("profilesStore");let defaultProfileModel;try{const defaultProfile=await adminLoginManager.loadDefaultProfile();await profileStore.asyncLoad({addRecords:!0});const[profileModel]=profileStore.add({...defaultProfile,isDefault:!0,name:"*web.config"});defaultProfileModel=profileModel}catch(error){return KSWN.ErrorHandler.handle(error),void this.closeView()}const appLoginParams=adminLoginManager.getAppLoginParams();if(appLoginParams)return void vm.setLoginParams(appLoginParams);const lastLoginParams=adminLoginManager.getLastLoginParams();if(lastLoginParams){const{profileId:profileId,...values}=lastLoginParams,lastLoginProfile=profileId?profileStore.getById(lastLoginParams.profileId):null;lastLoginProfile?vm.setProfile(lastLoginProfile):vm.setLoginParams(values)}else vm.setProfile(defaultProfileModel)},onRememberProfileCheckboxDisable:function(checkbox){checkbox.setValue(!1)},onLoginDBFormSubmitBtnClick:function(){this.loginComplex()},onLoginCPFormSubmitBtnClick:function(){this.loginCPanel()},onBeforeTabChange:function(tabs,tab){if(tab.isActivationTab)return this.loginActivation(),!1},onProfileComboboxSelect:function(combobox,profile){const vm=this.getViewModel();profile&&vm.set(profile.getLoginParams())},onFormFieldPaste:function(field,e){const clipboardData=e.getClipboardData();clipboardData&&this.trySetLoginReqsFromClipboardData(clipboardData).then(values=>{values&&values[field.name]&&field.setValue(values[field.name])})},onProfilesSettingsBtnClick:function(){this.showProfilesEditWin()},onBeforeProfileEditPropertyChange:function(source,field,value){if(!value&&"name"===field)return KSWN.core.messageBox.MessageBox.alert({messageType:"msg",message:KSWN.Locale.etopoleobyazatelnodlyazapolneniya}),!1},onProfileEditPropertyChange:function(source,field,value){const profile=this.getViewModel().getSelectedEditProfile();profile.set(field,value),profile.save()},onProfileEditCopyBtnClick:function(){const vm=this.getViewModel(),profileCopy=vm.getSelectedEditProfile().copy(null);profileCopy.save({callback:()=>{profileCopy.commit(),vm.getProfilesStore().add(profileCopy),vm.setSelectedEditProfile(profileCopy)}})},onProfileEditDeleteBtnClick:function(){const profile=this.getViewModel().getSelectedEditProfile();KSWN.core.messageBox.MessageBox.asyncConfirm({message:KSWN.Locale.vy_deystvitelno_hotite_udalit_vibraniy_profil}).then(confirm=>{confirm&&profile.erase()})},onProfileEditSelectionChange:function(profile){const grid=this.lookup("profilePropertyGrid");null==grid||grid.setSource(profile?profile.getEditData():null)},loginComplex:async function(){const res=await this.login();if(!res)return;const{result:result,loginParams:loginParams}=res;KSWN.util.QueryResult.isSuccess(result)&&this.onSuccessAuth(loginParams),this.getAdminLoginManager().processUserAuth(result,loginParams)},loginActivation:async function(){const res=await this.login();if(res)if(KSWN.util.QueryResult.isSuccess(res.result))this.getAdminLoginManager().openAppActivation();else{const errorMsg=KSWN.util.QueryResult.getErrorMessage(res.result);errorMsg&&KSWN.core.messageBox.MessageBox.alert({message:errorMsg,messageType:"err"})}},login:async function(){const form=this.lookup("loginDBForm"),vm=this.getViewModel();if(!form.isValid())return;const{login:login,password:password,dbName:dbName,dbServer:dbServer,dbType:dbType}=vm.getData(),params={login:login.trim(),dbName:dbName.trim(),dbServer:dbServer.trim(),rsa:KSWN.getConnection().getRSA(),dbType:dbType,password:password};return{result:await this.getAdminLoginManager().login(params),loginParams:params}},loginCPanel:async function(){const adminLoginManager=this.getAdminLoginManager(),vm=this.getViewModel();if(!this.lookup("loginCPForm").isValid())return;const{CPLogin:CPLogin,CPPassword:CPPassword}=vm.getData(),res=await this.getAdminLoginManager().CPLogin({login:CPLogin,password:CPPassword});if(!res)return KSWN.ExtUtils.Alert(KSWN.Locale.errnetdostupakkonfiguratoru);adminLoginManager.openCPanel(res)},trySetLoginReqsFromClipboardData:async function(loginParamsString){const vm=this.getViewModel();try{vm.set("parseConnectionStringInProgress",!0);const values=await this.getAdminLoginManager().parseLoginParamsString(loginParamsString);return values&&(values.password="",vm.set(values)),values}finally{vm.set("parseConnectionStringInProgress",!1)}},showProfilesEditWin:function(){this.getView().add({xtype:"ks-admin-login-profileseditwin",listeners:{destroy:"onProfileEditWinDestroy",scope:this}}).show()},onProfileEditWinDestroy:function(){this.getViewModel().setSelectedEditProfile(null)},onSuccessAuth:function(loginParams){const vm=this.getViewModel(),adminLoginManager=this.getAdminLoginManager(),paramsForSave=_.pick(loginParams,KSWN.admin.login.AdminLogin.loginParamsFields),profileName=this.lookup("profileCombobox").getRawValue();let profile=vm.get("selectedProfile");vm.get("rememberProfile")&&profileName&&(!profile||profile.isDefault()||profile.getName()!==profileName?profile=new KSWN.admin.login.model.Profile({name:profileName||"Профиль",...paramsForSave}):profile.set({...paramsForSave}),profile.save()),profileName&&profile&&profile.getName()===profileName?adminLoginManager.saveLastLoginParams({profileId:profile.getId(),...paramsForSave}):adminLoginManager.saveLastLoginParams(paramsForSave)},getAdminLoginManager:function(){return this.adminLoginManager||(this.adminLoginManager=this.view.adminLoginManager)}}),Ext.define("KSWN.admin.login.view.View",{extend:"Ext.panel.Panel",xtype:"ks-admin-login-view",layout:{type:"hbox",align:"center",pack:"center"},viewModel:"ks-admin-login",controller:"ks-admin-login",items:[{xtype:"panel",layout:{type:"vbox",align:"stretch"},border:1,header:!1,width:400,items:[{xtype:"ks-login-logo",flex:0},{xtype:"tabpanel",ui:"ks-login",bodyPadding:20,flex:1,listeners:{beforetabchange:"onBeforeTabChange"},items:[{xtype:"ks-admin-login-view-logindbform",reference:"loginDBForm"},{xtype:"ks-admin-login-view-logincpform",reference:"loginCPForm"},{xtype:"component",isActivationTab:!0,title:KSWN.Locale.aktivatsiya}]}]}]}),Ext.define("KSWN.admin.login.AdminLogin",{statics:{loginParamsFields:["dbName","dbServer","dbType","login"],appLoginParamsReqsFields:[],lastLoginParamsLocalStorageKey:"logindataadmin"},container:null,loginParams:null,constructor:function(config){this.initConfig(config),this.renderView(),this.initEvents()},renderView:function(){const view=new KSWN.admin.login.view.View({adminLoginManager:this});this.container.add(view),this.view=view},initEvents:function(){this.view.on({destroy:this.onViewDestroy,scope:this})},loadDefaultProfile:async function(){const res=await KSWN.getConnection().Ajax({url:"/AdminLogin/GetAdminProfile",noNeedSession:!0,catchError:!1});if(!res)throw new Error("#crit#"+KSWN.Locale.dostupzapreshchen);return res},getLastLoginParams:function(){return Ext.state.Manager.get(KSWN.admin.login.AdminLogin.lastLoginParamsLocalStorageKey,null)},saveLastLoginParams:function(params){Ext.state.Manager.set(KSWN.admin.login.AdminLogin.lastLoginParamsLocalStorageKey,params)},getAppLoginParams:function(){const{loginParams:loginParams}=this,params=KSWN.admin.login.AdminLogin.appLoginParamsReqsFields.reduce((obj,field)=>{const value=loginParams[field];return""!==value&&null!==value&&(obj[field]=value),obj},{});return _.isEmpty(params)?null:params},parseLoginParamsString:async function(loginParamsString){loginParamsString=loginParamsString.trim();const res=await Ajax({url:"/AdminLogin/ParseLoginParamsString",mask:{id:this.view},params:{loginParamsString:loginParamsString}});if(!res||!res.success)return null;const values=KSWN.admin.login.AdminLogin.loginParamsFields.reduce((obj,field)=>{const value=res.data[field];return null!==value&&(obj[field]=value),obj},{});return _.isEmpty(values)?null:values},login:function(loginParams){return KSWN.getConnection().Ajax({url:"/AdminLogin/Authorize",noNeedSession:!0,mask:{id:this.view,text:KSWN.Locale.vkhodvkompleks,cancel:!0},params:loginParams})},CPLogin:function(params){return KSWN.getConnection().Ajax({url:"/CPanel/FormAdminCPLogin",mask:{id:this.view,text:KSWN.Locale.analizdannikh},params:params})},openCPanel:function(params){KSWN.app.renderAdminCPanel(params)},processUserAuth:function(result,loginParams){KSWN.app.getLoginManager().ProcessUserAuth(result,loginParams)},openAppActivation:async function(){const win=await KSWN.core.task.Main.AppActivationWin();null==win||win.on({destroy:()=>{KSWN.app.getLoginManager().Logout()}})},onViewDestroy:function(){this.destroy()},destroy:function(){this.callParent()}},AdminLogin=>{AdminLogin.appLoginParamsReqsFields=[...AdminLogin.loginParamsFields,"password"]});