Ext.define("KSWN.core.screenshot.editor.ViewModel",{extend:"Ext.app.ViewModel",alias:"viewmodel.ks-core-screenshot-editor",data:{step:null,drawerTool:"pencil",drawerColor:"#000000",drawerWidth:"5",drawerFontSize:16,useScreenshotService:!1,linkTextAreaValue:""},formulas:{colorBtnBackgroundStyle:{bind:{bindTo:"{drawerColor}"},get:function(color){this.getView().lookup("toolbarColorPickBtn").setStyle("background-color",color)}},getImageUrlBtnHidden:{bind:{bindTo:"{step}"},get:function(step){return"draw"!==step||!this.get("useScreenshotService")}},copyToClipboardBtnHidden:{bind:{bindTo:"{step}"},get:function(step){return"draw"!==step||Ext.isGecko}},saveImageBtnHidden:{bind:{bindTo:"{step}"},get:function(step){return"crop"===step}}}}),Ext.define("KSWN.core.screenshot.editor.ViewController",{extend:"Ext.app.ViewController",alias:"controller.ks-core-screenshot-editor",init:function(){var _KSWN$getWebProject;this.getViewModel().set("step","crop"),this.getViewModel().set("useScreenshotService",(null===(_KSWN$getWebProject=KSWN.getWebProject())||void 0===_KSWN$getWebProject?void 0:_KSWN$getWebProject.useScreenshotService())||!1)},handleCrop:function(){const view=this.getView();view.screenshotSrc=view.cropper.crop(),this.getViewModel().set("step","draw")},handlePencilSelect:function(){this.getViewModel().set("drawerTool",KSWN.ux.image.DrawerToolEnum.Pencil)},handleColorPick:function(picker,color){this.getViewModel().set("drawerColor","#"+color)},handleLineSelect:function(){this.getViewModel().set("drawerTool",KSWN.ux.image.DrawerToolEnum.Line)},handleArrowSelect:function(){this.getViewModel().set("drawerTool",KSWN.ux.image.DrawerToolEnum.Arrow)},handleRectangleSelect:function(){this.getViewModel().set("drawerTool",KSWN.ux.image.DrawerToolEnum.Rect)},handleEllipseSelect:function(){this.getViewModel().set("drawerTool",KSWN.ux.image.DrawerToolEnum.Ellipse)},handleClear:function(){this.lookup("drawerCmp").resetSurface()},handleUndo:function(){this.lookup("drawerCmp").removeLastSprite()},handleTextSelect:function(){this.getViewModel().set("drawerTool",KSWN.ux.image.DrawerToolEnum.Text)},getImageUrl:async function(){if(!KSWN.getWebProject().useScreenshotService())return;const image=this.lookup("drawerCmp").getImage(),imgBlob=await KSWN.util.FileUtils.AsyncBase64ToBlob(image.data),res=await KSWN.getConnection().PostFilesAsync({url:"/Screenshot/SendScreenshot",filesKey:"screenshot",files:[imgBlob]});res.success?this.getViewModel().set({step:"link",linkTextAreaValue:res.data,drawerTool:null}):KSWN.MessageBox.alertMsg(KSWN.Locale.ne_udalos_zagruzit_izobrazhenie)},copyToClipboard:async function(){if(Ext.isGecko)return;const image=this.lookup("drawerCmp").getImage(),imgBlob=await KSWN.util.FileUtils.AsyncBase64ToBlob(image.data),data=[new ClipboardItem({[imgBlob.type]:imgBlob})];await navigator.clipboard.write(data)},handleImageSave:async function(){const image=this.lookup("drawerCmp").getImage(),imgBlob=await KSWN.util.FileUtils.AsyncBase64ToBlob(image.data),fileName="screenshot_"+(new Date).toLocaleDateString()+".png";await KSWN.util.FileUtils.SaveBlob(imgBlob,fileName)},onAboutProgramBtnClick:async function(){const vm=this.getViewModel(),info=await KSWN.system.InfoCollector.GetAsyncFullAppInfoText();vm.set("linkTextAreaValue",vm.get("linkTextAreaValue")+"\n\n"+info)},handleCancel:function(){const step=this.getViewModel().get("step");let isDirty="draw"===step||"link"===step;if(!isDirty){var _this$lookup;const{width:width,height:height}=(null===(_this$lookup=this.lookup("cropperCmp"))||void 0===_this$lookup?void 0:_this$lookup.getCropData())||{};isDirty=width&&height}isDirty?KSWN.MessageBox.confirm({message:"У вас есть несохраненные данные",description:"Продолжить?",callback:btn=>btn&&this.getView().destroy()}):this.getView().destroy()}}),Ext.define("KSWN.core.screenshot.editor.DrawStepToolbar",{extend:"Ext.toolbar.Toolbar",xtype:"ks-core-screenshot-editor-drawsteptoolbar",defaultType:"ks-ux-button",defaults:{enableToggle:!0,toggleOnClick:!1},items:[{reference:"toolbarPencilBtn",iconCls:KSWN.Constant.iconClsPrefix+"red_pencil",tooltip:KSWN.locale.Locale.karandash,handler:"handlePencilSelect",bind:{pressed:'{drawerTool === "pencil"}'}},{reference:"toolbarLineBtn",tooltip:KSWN.locale.Locale.liniya,iconCls:KSWN.Constant.iconClsPrefix+"line",handler:"handleLineSelect",bind:{pressed:'{drawerTool === "line"}'}},{reference:"toolbarArrowBtn",tooltip:KSWN.locale.Locale.strelka,iconCls:KSWN.Constant.iconClsPrefix+"screen_arrow",handler:"handleArrowSelect",bind:{pressed:'{drawerTool === "arrow"}'}},{reference:"toolbarRectBtn",tooltip:KSWN.locale.Locale.pryamougolnik,iconCls:KSWN.Constant.iconClsPrefix+"rectangle",handler:"handleRectangleSelect",bind:{pressed:'{drawerTool === "rect"}'}},{reference:"toolbarEllipseBtn",tooltip:KSWN.locale.Locale.ellips,iconCls:KSWN.Constant.iconClsPrefix+"ellips",handler:"handleEllipseSelect",bind:{pressed:'{drawerTool === "ellipse"}'}},{reference:"toolbarTextBtn",tooltip:KSWN.locale.Locale.text,iconCls:KSWN.Constant.iconClsPrefix+"text",handler:"handleTextSelect",bind:{pressed:'{drawerTool === "text"}'}},{reference:"toolbarColorPickBtn",tooltip:KSWN.locale.Locale.cvet,arrowVisible:!1,menu:{items:[{xtype:"colorpicker",reference:"toolbarColorPickMenu",listeners:{select:"handleColorPick"}}]}},{reference:"toolbarLineWidthBtn",tooltip:KSWN.locale.Locale.tolshina,iconCls:KSWN.Constant.iconClsPrefix+"line_weight",menu:{showSeparator:!1,items:[{xtype:"slider",reference:"toolbarLineWidthSlider",minValue:1,maxValue:20,bind:{value:"{drawerWidth}"}}]}},{reference:"toolbarFontSizeBtn",tooltip:KSWN.locale.Locale.razmer_shrifta,iconCls:KSWN.Constant.iconClsPrefix+"change_font",menu:{showSeparator:!1,items:[{xtype:"slider",reference:"toolbarFontSizeSlider",minValue:12,maxValue:26,bind:{value:"{drawerFontSize}"}}]}},"-",{reference:"toolbarUndoBtn",iconCls:KSWN.Constant.iconClsPrefix+"step_back",tooltip:KSWN.locale.Locale.otmenit+" (CTRL + Z)",handler:"handleUndo"},{reference:"toolbarClearBtn",iconCls:KSWN.Constant.iconClsPrefix+"clean",tooltip:KSWN.locale.Locale.steret_vse,handler:"handleClear"}]}),Ext.define("KSWN.core.screenshot.editor.View",{extend:"Ext.window.Window",xtype:"ks-core-screenshot-editor",viewModel:"ks-core-screenshot-editor",controller:"ks-core-screenshot-editor",title:KSWN.locale.Locale.snimok_ekrana,iconCls:KSWN.Constant.iconClsPrefix+"cut",autoShow:!0,autoHeight:!0,autoWidth:!0,modal:!0,maximizable:!0,layout:{type:"hbox",align:"stretch"},screenshotSrc:null,config:{step:null},bind:{step:"{step}"},tbar:[{xtype:"ks-core-screenshot-editor-drawsteptoolbar",reference:"drawStepToolbar",bind:{hidden:'{step !== "draw"}'}}],buttons:[{reference:"cropBtn",text:KSWN.locale.Locale.obrezat,handler:"handleCrop",bind:{hidden:'{step !== "crop"}'}},{reference:"saveImageBtn",text:KSWN.locale.Locale.sohranit_izobrazhenie,handler:"handleImageSave",bind:{hidden:"{saveImageBtnHidden}"}},{reference:"getImageUrlBtn",text:KSWN.locale.Locale.poluchit_ssilku,handler:"getImageUrl",bind:{hidden:"{getImageUrlBtnHidden}"}},{reference:"copyToClipboardBtn",text:KSWN.locale.Locale.skopirovat_v_bufer_obmena,handler:"copyToClipboard",bind:{hidden:"{copyToClipboardBtnHidden}"}},{reference:"cancelBtn",text:KSWN.locale.Locale.otmena,handler:"handleCancel"}],items:[{xtype:"panel",flex:1,reference:"editorPanel",layout:"fit",items:[]}],initComponent:function(){this.cropper=new KSWN.ux.image.Cropper({reference:"cropperCmp"}),this.callParent()},updateStep:function(step,prevStep){switch(prevStep&&"crop"===prevStep&&this.lookup("editorPanel").removeAll(),step){case"crop":this.setCropStep();break;case"draw":this.setDrawStep();break;case"link":this.setLinkStep()}},setCropStep:function(){this.cropper.setSrc(this.screenshotSrc),this.lookup("editorPanel").add(this.cropper)},setDrawStep:function(){this.lookup("editorPanel").add({xtype:"ks-ux-image-drawer",reference:"drawerCmp",src:this.screenshotSrc,bind:{tool:"{drawerTool}",currentColor:"{drawerColor}",currentLineWidth:"{drawerWidth}",fontSize:"{drawerFontSize}"}})},setLinkStep:function(){this.add({xtype:"panel",width:400,bodyPadding:7,layout:{type:"vbox",align:"stretch"},style:"border-left: 1px solid lightgrey",items:[{xtype:"textarea",grow:!0,growMax:500,bind:{value:"{linkTextAreaValue}"}},{defaultType:"button",defaults:{margin:"0 0 10 0"},layout:"vbox",items:[{xtype:"component",html:"Добавить:"},{text:"О программе",handler:"onAboutProgramBtnClick"},{text:"Текст ошибки",disabled:!0}]}]})}}),Ext.define("KSWN.core.screenshot.Screenshoter",{statics:{screenshoter:null,takeScreenshot:async function(){return this.screenshoter||(this.screenshoter=new KSWN.core.screenshot.Screenshoter),this.screenshoter.takeScreenshot()},takeScreenshotAndUpload:async function(){return this.screenshoter||(this.screenshoter=new KSWN.core.screenshot.Screenshoter),this.screenshoter.takeScreenshotAndUpload()},uploadScreenshot:async function(base64){const imgBlob=await KSWN.util.FileUtils.AsyncBase64ToBlob(base64);return KSWN.getConnection().PostFilesAsync({url:"/Screenshot/SendScreenshot",filesKey:"screenshot",files:[imgBlob]})}},takeScreenshot:async function(){let loadMask,el=arguments.length>0&&void 0!==arguments[0]?arguments[0]:document.body,mask=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];mask&&(loadMask=new Ext.LoadMask({msg:KSWN.Locale.sozdaniesnimkaekrana,target:KSWN.app.getMainView()}));try{var _loadMask;el.classList.add("screenshoter-no-transition"),null===(_loadMask=loadMask)||void 0===_loadMask||_loadMask.show();return(await html2canvas(el,{logging:!1,width:window.innerWidth,height:window.innerHeight,x:0,y:0,scale:2,foreignObjectRendering:Ext.isGecko,ignoreElements:element=>loadMask.getId()===element.id})).toDataURL()}finally{var _loadMask2;el.classList.remove("screenshoter-no-transition"),null===(_loadMask2=loadMask)||void 0===_loadMask2||_loadMask2.destroy()}},takeScreenshotAndUpload:async function(){const base64=await this.takeScreenshot(),res=await KSWN.core.screenshot.Screenshoter.uploadScreenshot(base64);if(res.success)return res.data;KSWN.MessageBox.alertMsg(KSWN.Locale.ne_udalos_zagruzit_izobrazhenie)}});