Ext.define("KSWN.core.bugSender.model.Bug",{extend:"Ext.data.Model",statics:{sendBugByPortal:function(){const params=Ext.Object.toQueryString({dd_hdn_Product_selector_values:"{4|Бюджет-WEB}",dd_hdn_OperatingSystem_selector_values:"{2|Windows}",dd_hdn_Component_selector_values:"",dd_hdn_Version_selector_values:"",dd_hdn_Severity_selector_values:""}),{keysystemsPortalUrl:keysystemsPortalUrl}=KSWN.Constant;KSWN.Utils.SilentAnchorClick(`${keysystemsPortalUrl}/Bugzilla.ks/NewBug?${params}`)},sendBugByBugzillaPortal:function(){KSWN.Utils.SilentAnchorClick("https://bugzilla.keysystems.ru/bugzilla/enter_bug.cgi?product=Бюджет-WEB")}},localStorageBugConfigKey:"ks-bugsender-bugconfig",fieldsForSend:["product","component","reporter","assignedTo","targetMilestone","deadline","shortDesc","longDesc","version","ccList"],bugConfigForSave:["product","component","reporter","version","targetMilestone","assignedTo","attachScreenshot","attachErrorText"],fields:[{name:"product",type:"int"},{name:"component",type:"int"},{name:"reporter",type:"int"},{name:"assignedTo",type:"int"},{name:"deadline",type:"date",defaultValue:new Date},{name:"targetMilestone",type:"string"},{name:"version",type:"string"},{name:"shortDesc",type:"string"},{name:"longDesc",type:"string"},{name:"attachScreenshot",type:"boolean"},{name:"attachErrorText",type:"boolean"},{name:"screenshotCaptured",type:"boolean",depends:["screenshotBase64"],calculate:_ref=>{let{screenshotBase64:screenshotBase64}=_ref;return null!=screenshotBase64}},{name:"screenshotBase64"},{name:"errorText"},{name:"ccList",convert:function(){let list=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[];const result={};return list.forEach(_ref2=>{let{data:data}=_ref2;result[data.Userid]=data.LoginName}),result}}],sendBug:async function(view){const dataForSend=await this.getDataForBugCreate(),res=await KSWN.getConnection().Ajax({url:"Bugzilla/SendBug",mask:{id:view,text:KSWN.Locale.otpravka},params:dataForSend});return res?(this.saveBugConfig(),res):0},setCCList:function(list){this.set("ccList",list)},getDataForBugCreate:async function(){const{fieldsForSend:fieldsForSend,data:data}=this,{attachErrorText:attachErrorText,attachScreenshot:attachScreenshot,errorText:errorText,screenshotBase64:screenshotBase64}=data,bugData=_.pick(data,fieldsForSend);if(attachErrorText&&(bugData.longDesc+="\n\n"+errorText),attachScreenshot)if(KSWN.getWebProject().useScreenshotService()){const res=await KSWN.core.screenshot.Screenshoter.uploadScreenshot(screenshotBase64);res.success&&(bugData.longDesc+="\n\n"+res.data,bugData.attachScreenshot=!1,bugData.screenshotBase64=null)}else bugData.screenshotBase64=_.chain(screenshotBase64).split(",").last().value();return bugData},loadBugConfig:function(){const{localStorageBugConfigKey:localStorageBugConfigKey,bugConfigForSave:bugConfigForSave}=this,cacheCfg=localStorage.getItem(localStorageBugConfigKey);let cfg=Ext.decode(cacheCfg,!0)||{};return cfg=_.pick(cfg,bugConfigForSave),cfg},saveBugConfig:function(){const{bugConfigForSave:bugConfigForSave,data:data,localStorageBugConfigKey:localStorageBugConfigKey}=this,cfg=_.pick(data,bugConfigForSave);localStorage.setItem(localStorageBugConfigKey,Ext.encode(cfg))}}),Ext.define("KSWN.core.bugSender.model.Product",{extend:"Ext.data.Model",idProperty:"Id",fields:[{name:"Id",type:"int"},{name:"Name",type:"string"}],hasMany:["Components","Milestones","Versions"],loadCVMData:async function(){const res=await Ajax({url:"/Bugzilla/GetProductCVM",params:{id:this.data.Id}});res&&this.set({Components:res.Components,Versions:res.Versions,Milestones:res.Milestones},{commit:!0})},hasCVMData:function(){return!!this.data.Components||!!this.data.Versions||!!this.data.Milestones},getVersions:function(){return this.data.Versions||[]},getComponents:function(){return this.data.Components||[]},getMilestones:function(){return this.data.Milestones||[]}}),Ext.define("KSWN.core.bugSender.model.User",{extend:"Ext.data.Model",idProperty:"UserId",fields:[{name:"UserId",type:"int"},{name:"FullName",type:"string",depends:["RealName","LoginName"],calculate:_ref3=>{let{RealName:RealName,LoginName:LoginName}=_ref3;return[RealName||"",LoginName||""].join(" ")}},{name:"RealName",type:"string"},{name:"LoginName",type:"string"},{name:"addToCC",type:"boolean"}]}),Ext.define("KSWN.core.bugSender.store.Products",{extend:"KSWN.core.data.Store",loadUrl:"Bugzilla/GetProducts",alias:"store.ks-bugsender-products",model:"KSWN.core.bugSender.model.Product"}),Ext.define("KSWN.core.bugSender.store.User",{extend:"KSWN.core.data.Store",loadUrl:"Bugzilla/GetUsers",alias:"store.ks-bugsender-users",model:"KSWN.core.bugSender.model.User"}),Ext.define("KSWN.core.bugSender.view.Form",{extend:"Ext.form.Panel",xtype:"ks-bugsender-form",defaultType:"fieldcontainer",bodyPadding:8,layout:{type:"vbox",align:"stretch"},defaults:{margin:"0 0 8 0",layout:{type:"hbox",align:"stretch"},defaults:{fieldLabelWidth:90,margin:"0 8 0 0",flex:1}},items:[{items:[{xtype:"combobox",fieldLabel:KSWN.Locale.produkt,displayField:"Name",valueField:"Id",queryMode:"local",forceSelection:!0,allowBlank:!1,bind:{store:"{productsStore}",value:"{bug.product}",selection:"{product}"},listeners:{select:"onProductComboboxSelect"}},{xtype:"combobox",fieldLabel:KSWN.Locale.komponent,displayField:"Name",valueField:"Id",queryMode:"local",grow:!0,forceSelection:!0,allowBlank:!1,listeners:{change:"onComponentComboboxValueChange"},bind:{store:"{productComponentsStore}",selection:"{component}",value:"{bug.component}"}}]},{items:[{xtype:"combobox",fieldLabel:KSWN.Locale.initsiator,displayField:"FullName",valueField:"UserId",queryMode:"local",grow:!0,forceSelection:!0,allowBlank:!1,bind:{store:"{reportersUserListStore}",value:"{bug.reporter}"}},{xtype:"combobox",fieldLabel:KSWN.Locale.ispolnitel,displayField:"FullName",valueField:"UserId",queryMode:"local",grow:!0,forceSelection:!0,allowBlank:!1,bind:{store:"{assignedToUserListStore}",value:"{bug.assignedTo}"}}]},{items:[{xtype:"datefield",fieldLabel:KSWN.Locale.krainiisrok,minValue:new Date,format:"d.m.Y",bind:"{bug.deadline}"},{xtype:"combobox",fieldLabel:KSWN.Locale.zaplanirovano,displayField:"Value",valueField:"Value",queryMode:"local",itemId:"milestone",forceSelection:!0,bind:{store:"{productMilestonesStore}",value:"{bug.targetMilestone}"}}]},{items:[{xtype:"combobox",fieldLabel:KSWN.Locale.versiya,displayField:"Value",valueField:"Value",queryMode:"local",itemId:"version",forceSelection:!0,bind:{store:"{productVersionsStore}",value:"{bug.version}"}},{xtype:"component"}]},{items:[{xtype:"textfield",fieldLabel:KSWN.Locale.annotatsiya,allowBlank:!1,bind:"{bug.shortDesc}"}]},{items:[{xtype:"textarea",fieldLabel:KSWN.Locale.opisanie,bind:{value:"{bug.longDesc}"}}],flex:1}]}),Ext.define("KSWN.core.bugSender.view.ССList",{extend:"Ext.panel.Panel",xtype:"ks-bugsender-cclist",bodyPadding:8,layout:{type:"vbox",align:"stretch"},items:[{xtype:"fieldcontainer",layout:{type:"hbox",align:"stretch"},items:[{xtype:"combobox",flex:1,labelWidth:150,displayField:"Name",valueField:"Userid",queryMode:"local",forceSelection:!0,margin:"0 8 0 0",listeners:{specialkey:"onAddUserToCCListComboboxSpecialKey"},bind:{store:"{notInCCUserListStore}",selection:"{userForAddToCCList}",value:"{userIdForAddToCCList}"}},{xtype:"button",flex:0,iconCls:"ks-icon-add",text:KSWN.Locale.dobavitpodpischika,handler:"onAddUserToCCListBtnClick",bind:{disabled:"{!userIdForAddToCCList}"}}]},{xtype:"ks-gridbase",reference:"usersGrid",stateful:!1,operationMode:"show",showFilter:!0,scrollable:!0,flex:1,stateId:"bugSenderUsersGr",border:1,columns:[{xtype:"checkcolumn",width:30,dataIndex:"addToCC"},{text:KSWN.Locale.imya,flex:1,dataIndex:"Name"}],bind:{store:"{inCCUserListStore}"}}]}),Ext.define("KSWN.core.bugSender.view.View",{extend:"Ext.window.Window",xtype:"ks-bugsender-panel",title:KSWN.Locale.registratsiyaoshibki,autoShow:!0,width:660,minWidth:560,maximizable:!0,modal:!1,autoHeight:!0,config:{bug:null},bind:{title:"{title}",loading:"{ usersStore.loading || productsStore.loading }"},applyBug:function(bug){return bug&&(bug.isModel||(bug=new KSWN.core.bugSender.model.Bug(bug)),this.lookupViewModel().set("bug",bug)),bug},doDestroy:function(){this.destroyMembers("bug"),this.callParent(arguments)},viewModel:"ks-bugsender",controller:"ks-bugsender",layout:{type:"vbox",align:"stretch"},items:[{xtype:"ks-bugsender-form",reference:"bugSendForm",title:KSWN.Locale.informatsiya,style:{borderBottom:"1px solid #cecece"},bind:{flex:"{bug.light}"}},{xtype:"ks-bugsender-cclist",title:KSWN.Locale.podpischiki,bind:{hidden:"{bug.light}"},flex:1}],fbar:[{xtype:"checkbox",boxLabel:KSWN.Locale.prikrepittekstoshibki,bind:{value:"{bug.attachErrorText}",hidden:"{bug.light}"}},{xtype:"tbspacer"},{xtype:"checkbox",boxLabel:KSWN.Locale.prikrepitsnimokekrana,bind:"{bug.attachScreenshot}"},"->",{text:KSWN.Locale.ok,handler:"sendBugBtnClick"},{text:KSWN.Locale.otmena,handler:"cancelBtnClick"}]}),Ext.define("KSWN.core.bugSender.view.ViewController",{extend:"Ext.app.ViewController",alias:"controller.ks-bugsender",sendBugBtnClick:async function(){const vm=this.getViewModel(),view=this.getView(),form=this.lookupReference("bugSendForm"),bug=vm.get("bug"),CCListStore=vm.get("inCCUserListStore");if(form.isValid()){bug.setCCList(CCListStore.getRange());const bugId=await bug.sendBug(view);if(bugId){const url="https://bugzilla.keysystems.ru/bugzilla/show_bug.cgi?id="+bugId;KSWN.Utils.SilentAnchorClick(url),view.close()}else KSWN.core.messageBox.MessageBox.alertMsg("#err#Ошибка создания бага")}else KSWN.ExtUtils.Alert(KSWN.Locale.msgdlyasozdaniyabaganeobkhodimozapolnitvseobyazatelniepolya)},onComponentComboboxValueChange:function(){const vm=this.getViewModel(),cmp=vm.get("component");cmp&&vm.set("bug.assignedTo",cmp.get("Initialowner"))},onProductComboboxSelect:function(combo,product){this.initProductCVM(product)},onProductStoreLoad:function(store){const bug=this.getViewModel().get("bug");let product=store.findRecord("Id",4,null,null,null,!0);if(product){const{product:bugProductId,...cachedBugConfig}=bug.loadBugConfig();let bugProduct;bugProductId&&(bugProduct=store.getById(bugProductId),bugProduct&&(product=bugProduct)),bug.set("product",product.getId()),this.initProductCVM(product).then(()=>{bugProduct&&bug.set(cachedBugConfig)})}else bug.sendBugByPortal(),this.getView().close()},addSelectionUserToCCList:function(){const vm=this.getViewModel(),user=vm.get("userForAddToCCList");user&&user.set("addToCC",!0),vm.set("userForAddToCCList",null)},onAddUserToCCListBtnClick:function(){this.addSelectionUserToCCList()},onAddUserToCCListComboboxSpecialKey:function(combobox,e){const key=e.getKey();key!==e.ENTER&&key!==e.TAB||this.addSelectionUserToCCList()},cancelBtnClick:function(){this.getView().close()},initProductCVM:async function(product){this.getView();const vm=this.getViewModel(),bug=vm.get("bug");product.hasCVMData()||await product.loadCVMData();const{Id:Id,Components:Components,Versions:Versions,Milestones:Milestones}=product.getData(),component=_.first(Components)||{},version=_.last(Versions)||{},milestone=_.last(Milestones)||{};vm.loadProductCVMStores({Components:Components,Versions:Versions,Milestones:Milestones}),bug.set({component:component.Id,version:version.Value,targetMilestone:milestone.Value})}}),Ext.define("KSWN.core.bugSender.view.ViewModel",{extend:"Ext.app.ViewModel",alias:"viewmodel.ks-bugsender",data:{bug:null,product:null,component:null,userForAddToCCList:null,userIdForAddToCCList:null},formulas:{title:{bind:{bindTo:"{bug.shortDesc}"},get:text=>KSWN.Locale.registratsiyaoshibki+(text?` «‎${text}»`:"")}},stores:{usersStore:{type:"ks-bugsender-users",autoLoad:!0},productsStore:{type:"ks-bugsender-products",autoLoad:!0,listeners:{outcomeload:"onProductStoreLoad"}},reportersUserListStore:{type:"chained",source:"{usersStore}"},assignedToUserListStore:{type:"chained",source:"{usersStore}"},notInCCUserListStore:{type:"chained",source:"{usersStore}",filters:[{property:"addToCC",value:!0,operator:"!="}]},inCCUserListStore:{type:"chained",source:"{usersStore}",filters:[{property:"addToCC",value:!0,operator:"="}]},productVersionsStore:{data:[],fields:["ProductId","Value","Id","Isactive"]},productComponentsStore:{data:[],fields:["Id","Name","ProductId","Initialowner","Initialqacontact","Description","Isactive"]},productMilestonesStore:{data:[],fields:["ProductId","Value","Sortkey","Id","Isactive"]}},loadProductCVMStores:function(_ref4){let{Components:Components,Versions:Versions,Milestones:Milestones}=_ref4;this.get("productVersionsStore").loadRawData(Versions),this.get("productComponentsStore").loadRawData(Components),this.get("productMilestonesStore").loadRawData(Milestones)}});